/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import com.technicalitiesmc.lib.util.Utils;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemSet
implements Iterable<Entry> {
    private final Set<Entry> entries = Utils.newIdentityHashSet();

    public static ItemSet of(IItemHandler inventory) {
        ItemSet set = new ItemSet();
        int slots = inventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            set.add(inventory.getStackInSlot(i));
        }
        return set;
    }

    @Nullable
    public Entry get(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)entry.identifier())) continue;
            return !entry.isEmpty() ? entry : null;
        }
        return null;
    }

    public int count(ItemStack stack) {
        Entry entry = this.get(stack);
        return entry != null ? entry.amount() : 0;
    }

    public int add(ItemStack stack) {
        return this.add(stack, stack.m_41613_());
    }

    public int add(ItemStack stack, int amount) {
        if (stack.m_41619_()) {
            return 0;
        }
        Entry entry = this.get(stack);
        if (entry != null) {
            entry.amount += amount;
            return entry.amount;
        }
        this.entries.add(new Entry(stack, amount));
        return amount;
    }

    public RemovalResult remove(ItemStack stack) {
        return this.remove(stack, stack.m_41613_());
    }

    public RemovalResult remove(ItemStack stack, int amount) {
        if (stack.m_41619_() || amount == 0) {
            return RemovalResult.NONE;
        }
        Entry entry = this.get(stack);
        if (entry != null) {
            return entry.shrink(amount);
        }
        return RemovalResult.NONE;
    }

    public ItemSet copy() {
        ItemSet set = new ItemSet();
        for (Entry entry : this.entries) {
            set.entries.add(new Entry(entry.identifier(), entry.amount()));
        }
        return set;
    }

    @Override
    @Nonnull
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public final class Entry {
        private final ItemStack identifier;
        private int amount;

        private Entry(ItemStack identifier, int amount) {
            this.identifier = identifier;
            this.amount = amount;
        }

        public ItemStack identifier() {
            return this.identifier;
        }

        public int amount() {
            return this.amount;
        }

        public boolean isEmpty() {
            return this.amount <= 0;
        }

        public int grow(int amount) {
            this.amount += amount;
            return this.amount;
        }

        public RemovalResult shrink(int amount) {
            int removed = Math.min(this.amount, amount);
            this.amount -= removed;
            if (removed == amount) {
                ItemSet.this.entries.remove(this);
            }
            return new RemovalResult(amount, this.amount);
        }

        public int split(int amount) {
            int removed = Math.min(this.amount, amount);
            this.amount -= removed;
            if (removed == amount) {
                ItemSet.this.entries.remove(this);
            }
            return removed;
        }
    }

    public record RemovalResult(int removed, int leftover) {
        private static final RemovalResult NONE = new RemovalResult(0, 0);
    }
}

